/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Last Modification:

    @version $Id: EtherCATMaster_Public.h 10657 2010-09-20 09:59:15Z Ulli $

   Description:

    -public definition of task

   Changes:

     Date        Author        Description
     ----------------------------------------------------------------------------------
     2007-11-20  UJ            moved __PACKED_POST behind struct (GCC < 4.0)
     2007-11-07  UJ            added bus scan stuff
     2007-11-01  UJ            created

**************************************************************************************/

#ifndef __ETHERCAT_MASTER_PUBLIC_H
#define __ETHERCAT_MASTER_PUBLIC_H

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'EtherCAT Master'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 ETHERCAT_MASTER_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(ETHERCAT_MASTER_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define ETHERCAT_MASTER_QUEUE_NAME        "QUE_EC_MASTER"

#define  ETHERCAT_MASTER_CMD_HOST_WDG_TIMEOUT_REQ            0x00650004
#define  ETHERCAT_MASTER_CMD_HOST_WDG_TIMEOUT_CNF            0x00650005

#define  ETHERCAT_MASTER_CMD_SDO_UPLOAD_REQ                  0x00650006
#define  ETHERCAT_MASTER_CMD_SDO_UPLOAD_CNF                  0x00650007

#define  ETHERCAT_MASTER_CMD_SDO_DOWNLOAD_REQ                0x00650008
#define  ETHERCAT_MASTER_CMD_SDO_DOWNLOAD_CNF                0x00650009

#define  ETHERCAT_MASTER_CMD_GET_ODLIST_REQ                  0x0065000A
#define  ETHERCAT_MASTER_CMD_GET_ODLIST_CNF                  0x0065000B

#define  ETHERCAT_MASTER_CMD_SET_BUSPARAM_REQ                0x0065000C
#define  ETHERCAT_MASTER_CMD_SET_BUSPARAM_CNF                0x0065000D

#define  ETHERCAT_MASTER_CMD_REGISTER_AT_STACK_REQ           0x0065000E
#define  ETHERCAT_MASTER_CMD_REGISTER_AT_STACK_CNF           0x0065000F

#define  ETHERCAT_MASTER_CMD_BUS_ON_REQ                      0x00650010
#define  ETHERCAT_MASTER_CMD_BUS_ON_CNF                      0x00650011

#define  ETHERCAT_MASTER_CMD_BUS_OFF_REQ                     0x00650012
#define  ETHERCAT_MASTER_CMD_BUS_OFF_CNF                     0x00650013

#define  ETHERCAT_MASTER_CMD_UPDATE_COMMUNICATION_STATE_IND  0x00650014
#define  ETHERCAT_MASTER_CMD_UPDATE_COMMUNICATION_STATE_RES  0x00650015

#define  ETHERCAT_MASTER_CMD_UPDATE_GLOBAL_SLAVE_INFO_IND    0x00650016
#define  ETHERCAT_MASTER_CMD_UPDATE_GLOBAL_SLAVE_INFO_RES    0x00650017

#define  ETHERCAT_MASTER_CMD_GET_OBJECTDESC_REQ              0x00650018
#define  ETHERCAT_MASTER_CMD_GET_OBJECTDESC_CNF              0x00650019

#define  ETHERCAT_MASTER_CMD_GET_ENTRYDESC_REQ               0x0065001A
#define  ETHERCAT_MASTER_CMD_GET_ENTRYDESC_CNF               0x0065001B

#define  ETHERCAT_MASTER_CMD_READ_EMERGENCY_REQ              0x0065001C
#define  ETHERCAT_MASTER_CMD_READ_EMERGENCY_CNF              0x0065001D

#define  ETHERCAT_MASTER_CMD_GET_DC_DEVIATION_REQ            0x0065001E
#define  ETHERCAT_MASTER_CMD_GET_DC_DEVIATION_CNF            0x0065001F

#define  ETHERCAT_MASTER_CMD_START_BUS_SCAN_REQ              0x00650020
#define  ETHERCAT_MASTER_CMD_START_BUS_SCAN_CNF              0x00650021

#define  ETHERCAT_MASTER_CMD_GET_BUS_SCAN_INFO_REQ           0x00650022
#define  ETHERCAT_MASTER_CMD_GET_BUS_SCAN_INFO_CNF           0x00650023


/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__ETHERCAT_MASTER_PACKET)
#endif

#define ETHERCAT_MASTER_BUSSTATE_UNKNOWN (0)  /* unknown */
#define ETHERCAT_MASTER_BUSSTATE_INIT    (1)  /* init */
#define ETHERCAT_MASTER_BUSSTATE_PREOP   (2)  /* pre-operational */
#define ETHERCAT_MASTER_BUSSTATE_BOOT    (3)  /* bootstrap mode */
#define ETHERCAT_MASTER_BUSSTATE_SAFEOP  (4)  /* safe operational */
#define ETHERCAT_MASTER_BUSSTATE_OP      (8)  /* operational */


/*************************************************************************************/
/* packets */


/*******************************************/
/*************Set Busparam Req/Cnf**********/
/*******************************************/

#define ETHERCAT_MASTER_AUTO_START (0x00000001)

#define ETHERCAT_MASTER_LEAVE_ALL_BROKEN_SLAVES_DOWN   (0x00000000)
#define ETHERCAT_MASTER_LEAVE_ADDRESS_LESS_SLAVES_DOWN (0x00000001)
#define ETHERCAT_MASTER_LEAVE_NO_SLAVES_DOWN           (0x00000002)



typedef struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_SET_BUSPARAM_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_REQ_DATA_Ttag
{
  TLR_UINT32    ulSystemFlags;          /* System Flags */
  TLR_UINT32    ulWdgTime;              /* Watchdog time */
  TLR_UINT32    ulBusCycleTime;         /* Bus Cycle Time in us */
  TLR_UINT32    ulBrokenSlaveBehaviour; /* Handling of slaves with error */
  TLR_BOOLEAN32 fDcActivated;           /* Activate Distributed Clocks */
  TLR_UINT32    ulReserved;
};


typedef struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_REQ_Ttag
      ETHERCAT_MASTER_PACKET_SET_BUSPARAM_REQ_T;

struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
  ETHERCAT_MASTER_PACKET_SET_BUSPARAM_REQ_DATA_T  tData;  /** packet request data. */
};


typedef struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_SET_BUSPARAM_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_CNF_DATA_Ttag
{
  TLR_HANDLE     hTrpInputData;        /* handle for the input triple buffer */
  TLR_HANDLE     hTrpOutputData;       /* handle for the output triple buffer */
  TLR_UINT32     ulInputDataSize;      /* size of the input data */
  TLR_UINT32     ulOutputDataSize;     /* size of the output data */
};


typedef struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_CNF_Ttag
      ETHERCAT_MASTER_PACKET_SET_BUSPARAM_CNF_T;

struct ETHERCAT_MASTER_PACKET_SET_BUSPARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;  /** packet header. */
  /* the data part is only used, if originator of the request-packet is the AP-Task */
  ETHERCAT_MASTER_PACKET_SET_BUSPARAM_CNF_DATA_T  tData;
};

/*******************************************/
/***Update Communication State Ind/Res******/
/*******************************************/

typedef struct ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_IND_DATA_Ttag
      ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_IND_DATA_T;

struct ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_IND_DATA_Ttag
{
  TLR_UINT32     ulCommunicationError;        /* last communication error */
  TLR_BOOLEAN32  fCommunicationActive;        /* equal to COM-Bit (at least one slave in cyclic date exchange) */
  TLR_UINT32     ulMasterBusState;            /* current Bus state (init, pre-op, ...) */
};

typedef struct ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_IND_Ttag
      ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_IND_T;

/* packet is send from the stack to the AP-Task to indicate changes in communication state */
struct ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_IND_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
  ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_IND_DATA_T  tData;  /** packet request data. */
};

typedef struct ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_RES_Ttag
      ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_RES_T;

struct ETHERCAT_MASTER_AP_PACKET_UPDATE_COMMUNICATION_STATE_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;  /** packet header. */
  /* the update communication state response has no data part */
};

/*******************************************/
/******Update Global Slave Info Ind/Res*****/
/*******************************************/

typedef struct ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_IND_DATA_Ttag
      ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_IND_DATA_T;

struct ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_IND_DATA_Ttag
{
  TLR_UINT32 ulSlaveState;         /* Slave status */
  TLR_UINT32 ulNumOfConfigSlaves;  /* Number of configured slaves */
  TLR_UINT32 ulNumOfActiveSlaves;  /* Number of active slaves */
  TLR_UINT32 ulNumOfDiagSlaves;    /* Number of slaves in diag mode */
};


typedef struct ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_IND_Ttag
      ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_IND_T;

/* packet is send from the stack to the AP-Task to indicate changes in slave state */
struct ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_IND_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
  ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_IND_DATA_T  tData;  /** packet request data. */
};


typedef struct ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_RES_Ttag
      ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_RES_T;

struct ETHERCAT_MASTER_AP_PACKET_UPDATE_GLOBAL_SLAVE_INFO_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;  /** packet header. */
  /* the update communication state response has no data part */
};


/*******************************************/
/**************Sdo Download Req/Cnf*********/
/*******************************************/

#define  ETHERCAT_MASTER_COE_MAX_SDO_DOWNLOAD_DATA (RCX_MAX_DATA_SIZE - (sizeof(TLR_UINT32) * 4))

typedef struct ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulSubIndex;
  TLR_UINT32 ulDataCnt;
  TLR_UINT8  abSdoData[ETHERCAT_MASTER_COE_MAX_SDO_DOWNLOAD_DATA];
};

typedef struct ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_REQ_Ttag
      ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_REQ_DATA_T  tData;  /** packet request data. */
};


/* the sdo download cnf needs no data part */
typedef struct ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_CNF_Ttag
      ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_CNF_T;

struct ETHERCAT_MASTER_PACKET_SDO_DOWNLOAD_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
};

/*******************************************/
/***************Sdo Upload Req/Cnf**********/
/*******************************************/
#define  ETHERCAT_MASTER_COE_MAX_SDO_UPLOAD_DATA (RCX_MAX_DATA_SIZE - (sizeof(TLR_UINT32) * 4))

typedef struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_SDO_UPLOAD_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulSubIndex;
};

typedef struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_REQ_Ttag
      ETHERCAT_MASTER_PACKET_SDO_UPLOAD_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_SDO_UPLOAD_REQ_DATA_T  tData;  /** packet request data. */
};

#define ETHERCAT_MASTER_COE_GET_SDO_UPLOAD_CNF_LEN_ON_ERROR (12)

typedef struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_SDO_UPLOAD_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_CNF_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulSubIndex;
  TLR_UINT32 ulDataCnt;
  TLR_UINT8  abSdoData[ETHERCAT_MASTER_COE_MAX_SDO_UPLOAD_DATA];
};


typedef struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_CNF_Ttag
      ETHERCAT_MASTER_PACKET_SDO_UPLOAD_CNF_T;

struct ETHERCAT_MASTER_PACKET_SDO_UPLOAD_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
  ETHERCAT_MASTER_PACKET_SDO_UPLOAD_CNF_DATA_T  tData;  /** packet request data. */
};


/*******************************************/
/**************Get OD List Req/Cnf**********/
/*******************************************/

#define  ETHERCAT_MASTER_COE_GET_ODLIST_DATA ((RCX_MAX_DATA_SIZE - (sizeof(TLR_UINT32) * 3)) / sizeof(TLR_UINT16))

#define ETHERCAT_MASTER_COE_GET_ODLIST_TYPE_ALL      (1)
#define ETHERCAT_MASTER_COE_GET_ODLIST_TYPE_RXPDOMAP (2)
#define ETHERCAT_MASTER_COE_GET_ODLIST_TYPE_TXPDOMAP (3)


typedef struct ETHERCAT_MASTER_PACKET_GET_ODLIST_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_ODLIST_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_ODLIST_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulListType;
};

typedef struct ETHERCAT_MASTER_PACKET_GET_ODLIST_REQ_Ttag
      ETHERCAT_MASTER_PACKET_GET_ODLIST_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_GET_ODLIST_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_GET_ODLIST_REQ_DATA_T  tData;  /** packet request data. */
};

#define ETHERCAT_MASTER_COE_GET_ODLIST_CNF_LEN_ON_ERROR (8)

typedef struct ETHERCAT_MASTER_PACKET_GET_ODLIST_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_ODLIST_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_ODLIST_CNF_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulListType;
  TLR_UINT32 ulDataCnt;
  TLR_UINT16 ausObjectList[ETHERCAT_MASTER_COE_GET_ODLIST_DATA];
};

typedef struct ETHERCAT_MASTER_PACKET_GET_ODLIST_CNF_Ttag
      ETHERCAT_MASTER_PACKET_GET_ODLIST_CNF_T;

struct ETHERCAT_MASTER_PACKET_GET_ODLIST_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
  ETHERCAT_MASTER_PACKET_GET_ODLIST_CNF_DATA_T  tData;  /** packet request data. */
};

/*******************************************/
/**********Get Object Desc Info Req/Cnf*****/
/*******************************************/

#define  ETHERCAT_MASTER_COE_GET_OBJECTDESC_NAME_LEN (RCX_MAX_DATA_SIZE - (sizeof(TLR_UINT32) * 7))


typedef struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;
};

typedef struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_REQ_Ttag
      ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_REQ_DATA_T  tData;  /** packet request data. */
};

#define ETHERCAT_MASTER_COE_GET_OBJECTDESC_CNF_LEN_ON_ERROR (8)

typedef struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_CNF_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;/* Index in the object dictionary */
  TLR_UINT32 ulDataType; /* Data type of the object */
  TLR_UINT32 ulObjCode; /* Object code */
  TLR_UINT32 ulObjCategory; /* Object category */
  TLR_UINT32 ulMaxNumSubIndex; /* Maximum sub index number */
  TLR_UINT32 ulObNameLen; /* Length of the object name */
  TLR_UINT8  abObjName[ETHERCAT_MASTER_COE_GET_OBJECTDESC_NAME_LEN]; /* Object name (not NULL terminated!) */
};

typedef struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_CNF_Ttag
      ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_CNF_T;

struct ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
  ETHERCAT_MASTER_PACKET_GET_OBJECTDESC_CNF_DATA_T  tData;  /** packet request data. */
};


/*******************************************/
/*************Get Entry Desc Req/Cnf********/
/*******************************************/

#define  ETHERCAT_MASTER_COE_GET_ENTRYDESC_MAX_DATA (RCX_MAX_DATA_SIZE - (sizeof(TLR_UINT32) * 11))


typedef struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulSubIndex;
  TLR_UINT32 ulAccessBitMask;
};

/* EtherCat CoE entry description value information bit definitions */
#define ETHERCAT_MASTER_COE_ENTRY_OBJACCESS              0x01
#define ETHERCAT_MASTER_COE_ENTRY_OBJCATEGORY            0x02
#define ETHERCAT_MASTER_COE_ENTRY_PDOMAPPING             0x04
#define ETHERCAT_MASTER_COE_ENTRY_UNITTYPE               0x08
#define ETHERCAT_MASTER_COE_ENTRY_DEFAULTVALUE           0x10
#define ETHERCAT_MASTER_COE_ENTRY_MINVALUE               0x20
#define ETHERCAT_MASTER_COE_ENTRY_MAXVALUE               0x40

typedef struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_REQ_Ttag
      ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_REQ_DATA_T  tData;  /** packet request data. */
};


typedef struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_CNF_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;/* Index in the object dictionary */
  TLR_UINT32 ulSubIndex;
  TLR_UINT32 ulValueInfo; /* Bit mask to define which information is available */
  TLR_UINT32 ulDataType; /* Object data type */
  TLR_UINT32 ulBitLen; /* Object size (number of bits) */
  TLR_UINT32 ulObAccess; /* Access rights */
  TLR_BOOLEAN32 fRxPdoMapping; /* Is the object PDO-mappable? */
  TLR_BOOLEAN32 fTxPdoMapping; /* Can the PDO be changed */
  TLR_UINT32 ulUnitType; /* Unit*/
  TLR_UINT32 ulDataLen; /* Size of the remaining object data */
  TLR_UINT8  abObjData[ETHERCAT_MASTER_COE_GET_ENTRYDESC_MAX_DATA]; /* Remaining object data (see EtherCAT specification) */
};

#define ETHERCAT_MASTER_COE_GET_ENTRYDESC_CNF_LEN_ON_ERROR (12)


typedef struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_CNF_Ttag
      ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_CNF_T;

struct ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_CNF_Ttag
{
  TLR_PACKET_HEADER_T                              tHead;  /** packet header. */
  ETHERCAT_MASTER_PACKET_GET_ENTRYDESC_CNF_DATA_T  tData;  /** packet request data. */
};

/*******************************************/
/*************Emergency Info Req/Cnf********/
/*******************************************/

#define ETHERCAT_MASTER_COE_NUMBER_OF_EMERGENCY (5)
#define ETHERCAT_MASTER_COE_EMERGENCY_DATA_BYTES (5)

typedef struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_REQ_DATA_Ttag
{
  TLR_UINT32 ulSlaveHandle;
  TLR_BOOLEAN32 fDeleteEmergency;  /* Flag to decide (keep emergeny(s) / clear emergeny(s)) */
};

typedef struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_REQ_Ttag
      ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                     tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_REQ_DATA_T  tData;  /** packet request data. */
};

typedef struct ETHERCAT_MASTER_SLAVE_EMERGENCY_Ttag
      ETHERCAT_MASTER_SLAVE_EMERGENCY_T;

__PACKED_PRE struct ETHERCAT_MASTER_SLAVE_EMERGENCY_Ttag
{
  TLR_UINT16 usErrorCode;
  TLR_UINT8  bErrorRegister;
  TLR_UINT8  abErrorData[ETHERCAT_MASTER_COE_EMERGENCY_DATA_BYTES];
}__PACKED_POST ;

typedef struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_CNF_DATA_T;

__PACKED_PRE struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_CNF_DATA_Ttag
{
  TLR_UINT32 ulSlaveHandle;
  TLR_BOOLEAN32 fDeleteEmergency;  /* value from request */
  TLR_BOOLEAN32 fOverflowOccured;  /* Emergency dropped cause of full buffer */
  ETHERCAT_MASTER_SLAVE_EMERGENCY_T atEmergenyBuffer[ETHERCAT_MASTER_COE_NUMBER_OF_EMERGENCY]; /* up to five emergencies */
} __PACKED_POST;

typedef struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_CNF_Ttag
      ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_CNF_T;

struct ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header. */
  ETHERCAT_MASTER_PACKET_SLAVE_EMERGENCY_INFO_CNF_DATA_T  tData;  /** packet request data. */
};



#define  ETHERCAT_MASTER_GET_DC_DEVIATION_NUMOFSLAVES ((RCX_MAX_DATA_SIZE - sizeof(TLR_UINT32))/sizeof(TLR_UINT32))


typedef struct ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_REQ_Ttag
      ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_REQ_T;

struct ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_REQ_Ttag
{
  /* the request needs no data part */
  TLR_PACKET_HEADER_T                                 tHead;  /** packet header. */
};


typedef struct ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_CNF_DATA_Ttag
{
  TLR_UINT32 ulBroadcastDeviation;
  TLR_UINT32 aulSlaveDeviation[ETHERCAT_MASTER_GET_DC_DEVIATION_NUMOFSLAVES] ;
};

typedef struct ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_CNF_Ttag
      ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_CNF_T;

struct ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;  /** packet header. */
  ETHERCAT_MASTER_PACKET_GET_DC_DEVIATION_CNF_DATA_T  tData;  /** packet request data. */
};


typedef struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_START_BUS_SCAN_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_REQ_DATA_Ttag
{
  TLR_UINT32 ulTimeout;
};

typedef struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_REQ_Ttag
      ETHERCAT_MASTER_PACKET_START_BUS_SCAN_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_REQ_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_START_BUS_SCAN_REQ_DATA_T  tData;  /** packet request data. */
};

typedef struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_START_BUS_SCAN_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_CNF_DATA_Ttag
{
  TLR_UINT32 ulFoundSlaves;
};

typedef struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_CNF_Ttag
      ETHERCAT_MASTER_PACKET_START_BUS_SCAN_CNF_T;

/**  */
struct ETHERCAT_MASTER_PACKET_START_BUS_SCAN_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_START_BUS_SCAN_CNF_DATA_T  tData;  /** packet confirmation data. */
};




typedef struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_REQ_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_REQ_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_REQ_DATA_Ttag
{
  TLR_UINT16 usAutoIncAddr;
};

typedef struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_REQ_Ttag
      ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_REQ_T;

/**  */
struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                  tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_REQ_DATA_T  tData;  /** packet request data. */
};

typedef struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_CNF_DATA_Ttag
      ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_CNF_DATA_T;

struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_CNF_DATA_Ttag
{
  TLR_UINT32 ulVendorId;
  TLR_UINT32 ulProductCode;
  TLR_UINT32 ulRevisionNumber;
  TLR_UINT32 ulSerialNumber;
  TLR_UINT32 ulPortState;
};

typedef struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_CNF_Ttag
      ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_CNF_T;

/**  */
struct ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                  tHead;  /** packet header.       */
  ETHERCAT_MASTER_PACKET_GET_BUS_SCAN_INFO_CNF_DATA_T  tData;  /** packet confirmation data. */
};


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__ETHERCAT_MASTER_PACKET)
#endif

/*************************************************************************************/
#endif /* #ifndef __ETHERCAT_MASTER_PUBLIC_H */
